local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// button.
function PANEL:Init( )
	// label.
	self.Label = vgui.Create( "label", self );
	self.Label:SetMouseInputEnabled( false );
	
	// linked to
	self.LinkedClass = nil;
	
	// no image list
	self.ImageList = nil;
	
	// icon!
	self.Icon = nil;
	
end


// set icon
function PANEL:SetIcon( mat )
	// create
	if( !self.Icon ) then
		self.Icon = vgui.Create( "ctl_icon", self );
		self.Icon:SetMouseInputEnabled( false );
		
	end
	
	// full texture.
	if( type( mat ) == "string" ) then
		self.Icon:SetMaterial( mat );
		
	// imagelist?
	elseif( type( mat ) == "number" && self.ImageList ) then
		local texture = self.ImageList:Get( mat );
		if( texture ) then
			self.Icon.Material = texture;
			
		end
	
	end
	
end

// set caption
function PANEL:SetText( txt )
	self.Label:SetText( txt );
	
end



// perform layout
function PANEL:PerformLayout( )
	// auto size the label
	self.Label:SizeToContents();
	
	// width/height
	local width, height = self:GetSize();
	
	// label offsets.
	local ofsy = ( height * 0.5 ) - ( self.Label:GetTall() * 0.5 );
	local ofsx = 8;
	
	// icon?
	if( self.Icon ) then
		// position the icon.
		self.Icon:SetPos( ofsx, self:GetTall() * 0.5 - 8 );
		self.Icon:SetSize( 16, 16 );
		
		// shift offset.
		ofsx = 28;
	
	end
	
	// set label position.
	self.Label:SetPos( ofsx, ofsy );
	
end

// scheme
function PANEL:ApplySchemeSettings( )
	// set label colors
	self.Label:SetFont( AppFramework:Theme().fonts['text'] );
	self.Label:SetFGColor( AppFramework:Theme().colors['text'] );
	
end


// on clicked
function PANEL:DoClick( )
	// exec
	if( self.LinkedClass ) then
		self.LinkedClass:CallEvent( "OnClick" );
		
	end
	
end



// draw
function PANEL:Paint( )
	// calculate color.
	local color = AppFramework:CopyColor( AppFramework:Theme().colors['button_face'] );
	if( self.Armed && !self.Depressed ) then
		// calculate delta
		local delta = math.sin( CurTime() * 8 ) * 15;
		
		// adjust color, clamping to the valid range.
		color.r = math.Clamp( color.r + delta, 0, 255 );
		color.g = math.Clamp( color.g + delta, 0, 255 );
		color.b = math.Clamp( color.b + delta, 0, 255 );

	end
	
	// depressed
	if( self.Depressed ) then
		AppFramework:Theme():DrawFrame( 0, 0, self:GetWide(), self:GetTall(), FRAME_INSET, color );
		
	// normal
	else
		AppFramework:Theme():DrawFrame( 0, 0, self:GetWide(), self:GetTall(), FRAME_OUTSET, color );
		
	end
	
	//
	return true;
	
end

// register
vgui.Register( "ctl_button", PANEL, "Button" );




// create app framework control.
CtlButton_class 	= Control_class:create( nil, false, "ctl_button" );


// set text
function CtlButton_class:SetText( txt )
	self:GetHandle():SetText( txt );	

end

// set imagelist.
function CtlButton_class:SetImageList( list )
	self:GetHandle().ImageList = list;
	
end

// set icon
function CtlButton_class:SetIcon( icon )
	self:GetHandle():SetIcon( icon );

end
